@echo off
REM Intelligent 3D Icons Uninstall Process -- Restore Old Icons

REM Installation for Intelligent 3D Icons v1.1
REM by Albert Kan
REM Email: syk108@email.psu.edu
REM Homepage: http://www.personal.psu.edu/syk108
REM October 1, 1996

REM ------------------------------------------------------------
REM Program Starts.
REM ------------------------------------------------------------

if exist "%WinDir%\Command\Xcopy.exe" set XCOPY=TRUE
if exist "%WinDir%\Command\Choice.com" set CHOICE=TRUE
if exist "%WinDir%\Command\Attrib.com" goto Err

if not exist "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" goto ErrReg
if not exist "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" goto ErrReg

if not %CHOICE%==TRUE goto Noask

if not %XCOPY%==TRUE goto NoXC

:WARNING
Echo WARNING! If you have installed new applications or changed the Registry
Echo          after this Backup is made, the new applications will not function
Echo          properly.
Echo .
Echo Continue? [y/n]
%WinDir%\Command\Choice.com /n /c:yn
if errorlevel 2 goto Exit
goto Ask

:Ask
Echo .
Echo .
Echo Do you want to restore old icons? [y/n]
%WinDir%\Command\Choice.com /n /c:yn
if errorlevel 2 goto Exit

Echo .
Echo Restore backup Registry setting will replace the current Registry. Any new
Echo settings or information will be lost.
Echo .
Echo Continue? [y/n]
%WinDir%\Command\Choice.com /n /c:yn
if errorlevel 2 goto Exit
goto Restore

:Restore
Echo .
Echo .
Echo Restoring Icons...

%WinDir%\Command\Attrib -r -s -h "%WinDir%\System.dat"
%WinDir%\Command\Attrib -r -s -h "%WinDir%\User.dat"

if not %XCOPY%==TRUE goto NoXC

%WinDir%\Command\Xcopy "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" "%WinDir%" /y > nul
%WinDir%\Command\Xcopy "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" "%WinDir%" /y > nul

:contrestore
%WinDir%\Command\Attrib +r +s +h "%WinDir%\System.dat"
%WinDir%\Command\Attrib +r +s +h "%WinDir%\User.dat"

Echo .
Echo Old Settings are restored.
Goto Complete

:NoXC
copy "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" "%WinDir%" /y > nul
copy "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" "%WinDir%" /y > nul
goto contrestore

:NoAsk
Echo WARNING! If you have installed new applications or changed the Registry
Echo          after this Backup is made, the new applications will not function
Echo          properly.
Echo .
Echo Press CTRL-C to exit,
Echo Press any key to continue.
pause > nul
goto Confirm

:Confirm
Echo .
Echo .
Echo Do you want to restore old icons?
Echo .
Echo Press CTRL-C to exit,
Echo Press any key to continue.

Echo .
Echo Restore backup Registry setting will replace the current Registry. Any new
Echo settings or information will be lost.
Echo .
Echo Press CTRL-C now to exit,
Echo Press any key will restore icons.
goto Restore

:Err
Echo .
Echo Cannot find Attrib.exe, uninstall cannot continue.
Goto ErrCommon

:ErrReg
Echo .
Echo Cannot find Registry Backup Files.
Echo - Registry Backup -- System.dat.bak is missing.
Echo - Registry Backup -- User.dat.bak   is missing.
goto ErrCommon

:ErrCommon
Echo .
Echo Please contact me at syk108@email.psu.edu
Echo .
pause
goto End

:Exit
Echo .
Echo .
Echo Job terminated by user.
goto End

:Complete
Echo .
Echo .
Echo Restore Process completed.
Echo .
pause
goto End

REM ------------------------------------------------------------
REM Program Ends.
REM ------------------------------------------------------------

:End
set REG=
set XCOPY=
set CHOICE=

REM [End of Program] (EOF)